<?php
function next_post_types() 
{
	/*---Portfolio custom post ----*/
	register_post_type( 'portfolio_item',
		array(
			'labels' => array(
				'name' => __( 'Portfolio' ,'nextlang'),
				'singular_name' => __( 'Project' ,'nextlang'),
				'add_new' => __( 'Add New Project' ,'nextlang'),
				'add_new_item' => __( 'Add New Project' ,'nextlang'),
				'edit' => __( 'Edit Project','nextlang' ),
				'edit_item' => __( 'Edit Project','nextlang' ),
			),
			'description' => __( 'Portfolio Items.','nextlang' ),
			'public' => true,
			'supports' => array( 'title', 'editor','thumbnail' ),
			'rewrite' => array( 'slug' => 'proxitem', 'with_front' => false ),
			'has_archive' => true,
			'show_in_menu' => true,
			'menu_position' => 7,
			'menu_icon' => get_template_directory_uri() . '/admin/assets/images/custom/glyphicons_155_show_thumbnails.png',
		)
	);
	register_taxonomy( 'portfolio_category', array( 'portfolio_item' ),
	array( 'hierarchical' => true, 'label' => "Categories","singular_label" => "Category" ) );	
}

/*---------------------------------------------
-------------Gallery Post Type---------------
----------------------------------------------*/
function next_post_gallery() 
{
	/*---Portfolio custom post ----*/
	register_post_type( 'metro_tiles',
		array(
			'labels' => array(
				'name' => __( 'Metro Tiles' ,'nextlang'),
				'singular_name' => __( 'Metro Tile' ,'nextlang'),
				'add_new' => __( 'Add New Tile' ,'nextlang'),
				'add_new_item' => __( 'Add New Tile' ,'nextlang'),
				'edit' => __( 'Edit Tile','nextlang' ),
				'edit_item' => __( 'Edit Tile','nextlang' ),
			),
			'description' => __( 'Metro Tiles','nextlang' ),
			'public' => true,
			'supports' => array( 'title','page-attributes'),
			'rewrite' => array( 'slug' => 'metrotiles', 'with_front' => false ),
			'has_archive' => true,
			'show_in_menu' => true,
			'menu_position' => 8,
			'menu_icon' => get_template_directory_uri() . '/admin/assets/images/custom/images.png',
		)
	);
}

/*------Services--------*/
function next_services_type() 
{
	/*---Portfolio custom post ----*/
	register_post_type( 'services',
		array(
			'labels' => array(
				'name' => __( 'Services' ,'nextlang'),
				'singular_name' => __( 'Service' ,'nextlang'),
				'add_new' => __( 'Add New Service' ,'nextlang'),
				'add_new_item' => __( 'Add New Service' ,'nextlang'),
				'edit' => __( 'Edit Service','nextlang' ),
				'edit_item' => __( 'Edit Service','nextlang' ),
			),
			'description' => __( 'Services Explained.','nextlang' ),
			'public' => true,
			'supports' => array( 'title', 'editor','thumbnail' ),
			// 'rewrite' => array( 'slug' => 'proxserviceitem', 'with_front' => false ),
			'rewrite' => array( 'slug' => 'services', 'with_front' => false ),
			'has_archive' => true,
			'show_in_menu' => true,
			'menu_position' => 7,
			'menu_icon' => get_template_directory_uri() . '/admin/assets/images/custom/wrench.png',
		)
	);
	register_taxonomy( 'services_category', array( 'services' ),
	array( 'hierarchical' => true, 'label' => "Categories","singular_label" => "Category" ) );		
}




?>