<?php
/**
 * Define the metabox and field configurations.
 *
 * @param  array $meta_boxes
 * @return array
 */
function cmb_sample_metaboxes( array $meta_boxes ) {

/*-------------------------------------------
Portfolio
-------------------------------------------*/
    $portfolio_options = array(
		array( 'id' => 'next_port_displaymode',  'name' => 'Portfolio Display Style', 'type' => 'select',
			'options' => array(
                       'dataexpand' => __( 'Ajax Data Expansion', 'nextlang' ),
                       'lightbox' => __( 'Lightbox Image', 'nextlang' ),
                       'lightboxyoutube' => __( 'Lightbox Youtube Video', 'nextlang' ),
                       )
			),
		array( 'id' => 'next_port_youtube', 'name' => 'Youtube Video ID', 'type' => 'text' ),
		array( 'id' => 'next_port_vimeo', 'name' => 'Vimeo Video ID', 'type' => 'text' ),
		array( 'id' => 'next_port_lightbox', 'name' => 'Image for Lightbox', 'type' => 'image' ),
        array( 'id' => 'next_port_sliderimages', 'name' => 'Add Images to Slider', 'type' => 'image', 'repeatable' => true,'repeatable_max' => 10),
        array( 'id' => 'next_port_bgcolor', 'name' => 'Background Color', 'type' => 'colorpicker' ),   
   );
	$meta_boxes[] = array(
		'title' => 'Portfolio Options',
		'pages' => 'portfolio_item',
		'fields' => $portfolio_options
	);

/*-------------------------------------------
 Page Options One
-------------------------------------------*/
 $page_options_basic = array(
        array( 'id' => 'next_include_onepage', 'name' => 'Include to one page', 'type' => 'checkbox' ),       
        array( 'id' => 'next_menu_icon', 'name' => 'Icon for Side-Menu ', 'type' => 'image' ),    
        array( 'id' => 'next_pagebg_color', 'name' => 'Page Background Color', 'type' => 'colorpicker','default' => '#FFFFFF' ),  
        array( 'id' => 'next_pagehead_color', 'name' => 'Heading Text Color', 'type' => 'colorpicker', 'default' => '#FFFFFF'),
        array( 'id' => 'next_pageheadbg_color', 'name' => 'Heading Section BG color', 'type' => 'colorpicker','default' => '#40484F' ),
        array( 'id' => 'next_pagemenu_color',  'name' => 'Side-menu Menu Background Color', 'type' => 'colorpicker'),
   );
	$meta_boxes[] = array(
		'title' => 'Common Page Options',
		'pages' => 'page',
		'fields' => $page_options_basic
	);


// /*-------------------------------------------
// Posts
// -------------------------------------------*/
 $post_options_basic = array(

array( 'id' => 'next_post_blogslider', 'name' => 'Add Images to Slider', 'type' => 'image', 'repeatable' => true,'repeatable_max' => 10),
array( 'id' => 'next_post_videoembed',  'name' => 'Video Embed Code', 'type' => 'textarea'  ),
array( 'id' => 'next_post_quote',  'name' => 'Quote (Only for Quote post format)', 'type' => 'textarea'  ),
array( 'id' => 'next_post_soundcloud',  'name' => 'Sound Cloud Embed (Only for audio post format)', 'type' => 'textarea'  ),
array( 'id' => 'next_post_linkpost',  'name' => 'Link (Only for Link post format)', 'type' => 'text'  ),
);

 $meta_boxes[] = array(
		'title' => 'Post Enhancement Options',
		'pages' => 'post',
		'fields' => $post_options_basic 
	);

/*-------------------------------------------
Services Post Options
-------------------------------------------*/
    $services_post_op = array(
		array( 'id' => 'next_serv_tilewidth',  'name' => 'Services Tile Width', 'type' => 'select',
			'options' => array(
                       '1' => __( 'One Fourth', 'nextlang'),
                       '2' => __( 'Two Fourth', 'nextlang'),
                       '4' => __( 'Full Length', 'nextlang'),
                       )
			),
		array( 'id' => 'next_serv_tilecolor', 'name' => 'Tile Background Color', 'type' => 'colorpicker','default' => '#BC2721' ),
        array( 'id' => 'next_serv_tileicon', 'name' => 'Tile Icon', 'type' => 'image','default' => '#FFFFFF' ),
        array( 'id' => 'next_serv_subheading',  'name' => 'Sub-Heading', 'type' => 'text' ),
        array( 'id' => 'next_serv_subheading_two',  'name' => 'Sub-Heading Inner', 'type' => 'text','default' => ''  ),
        array( 'id' => 'next_serv_sliderimages', 'name' => 'Add Images to the inner slider', 'type' => 'image', 'repeatable' => true,'repeatable_max' => 10),
   );
	$meta_boxes[] = array(
		'title' => 'Services Meta Option',
		'pages' => 'services',
		'fields' => $services_post_op
	);
/*-------------------------------------------
Metro Tiles Post Options
-------------------------------------------*/
$metro_tiles_parent = array(
		array( 'id' => 'next_metro_tilebehaviour',  'name' => 'Tile Behaviour', 'type' => 'select',
			'options' => array(
                       'infotile'    => __( 'Info Tile', 'nextlang' ),
                       'titletile'   => __( 'Title Tile', 'nextlang' ),
                       'trasparent'  => __( 'Trasparent/Space Adjuster', 'nextlang' ),
                       'imageflip'   => __( 'Image Flip', 'nextlang' ), 
                       )
			),
		array( 'id' => 'next_metro_tilewidth',  'name' => 'Tile Width', 'type' => 'select',
			'options' => array(
                       '1' => '1',
                       '2' => '2',
                       '3' => '3',
                       '4' => '4',
                       '5' => '5',
                       '6' => '6',
                       )
			),		
   );
	$meta_boxes[] = array(
		'title' => 'Tile Settings',
		'pages' => 'metro_tiles',
		'fields' => $metro_tiles_parent
	);

/*Image flips*/
    $metro_tiles_img = array(
		array( 'id' => 'next_metroif_orientation',  'name' => 'Flip Behaviour', 'type' => 'select',
			'options' => array(
                       'vertical'    => __( 'Vertical Flips', 'nextlang'),
                       'horizontal'  => __( 'Horizontal Flips', 'nextlang'),
                       'noflip'      => __( 'No Flip', 'nextlang'),
                       )
			),
       array( 'id' => 'next_metroif_images', 'name' => 'Images for both sides (Flip)', 'type' => 'image', 'repeatable' => true,'repeatable_max' => 2),	
       array( 'id' => 'next_metroif_link',  'name' => 'Link the Image','desc' => 'Absolute URL', 'type' => 'text' ),
   );
	$meta_boxes[] = array(
		'title' => 'Tile Settings - Image Flips',
		'pages' => 'metro_tiles',
		'fields' => $metro_tiles_img
	);
/*--------------------Info Tiles------------*/
  $metro_tiles_it = array(
       array( 'id' => 'next_metroit_icon', 'name' => 'Tile Icon', 'type' => 'image', 'repeatable' => true,'repeatable_max' => 2),	
       array( 'id' => 'next_metroit_desc', 'name' => 'Description','desc' => 'Short Description', 'type' => 'textarea' ),
       array( 'id' => 'next_metroif_linktext', 'name' => 'Link Label','desc' => 'Label', 'type' => 'text' ),
       array( 'id' => 'next_metroit_link', 'name' => 'Link','desc' => 'URL', 'type' => 'text' ),
       array( 'id' => 'next_metroit_bgcolor', 'name' => 'Tile Background','desc' => 'URL', 'type' => 'colorpicker' ),
       array( 'id' => 'next_metroit_bghover', 'name' => 'Background on Hover','desc' => 'URL', 'type' => 'colorpicker' ),
   );
	$meta_boxes[] = array(
		'title' => 'Tile Settings - Info Tile',
		'pages' => 'metro_tiles',
		'fields' => $metro_tiles_it
	);
/*-----------------Title------------*/
  $metro_tiles_tt = array(
       array( 'id' => 'next_metrott_subheading', 'name' => 'Link','desc' => 'URL', 'type' => 'text' ,'size' => 80 ),
   );
	$meta_boxes[] = array(
		'title' => 'Tile Settings - Title Tile',
		'pages' => 'metro_tiles',
		'fields' => $metro_tiles_tt
	);

/*-------------------------------------------
Sub Section Groups for pages
-------------------------------------------*/  
	$fields = array(
        array( 'id' => 'next_pagesubsection_title', 'name' => 'Sub-Section Title', 'type' => 'text' ),
 		array( 'id' => 'next_pagesubsection_content', 'name' => 'Sub-Section Content', 'type' => 'wysiwyg', 'desc' => 'Contents'),
		array( 'id' => 'next_pagesubsection_bgcolor', 'name' => 'Sub-section Background Color', 'type' => 'colorpicker' ),
		array( 'id' => 'next_pagesubsection_headcolor',  'name' => 'Heading Text Color', 'type' => 'colorpicker' ),

	);
	$group_fields = $fields;
	$meta_boxes[] = array(
		'title' => 'Sub Sections',
		'pages' => 'page',
		'fields' => array(
			array( 
				'id' => 'gp', 
				'name' => 'Sub-Sections', 
				'type' => 'group', 
				'repeatable' => true,
				'sortable' => true,
				'fields' => $group_fields,
				'desc' => 'Page Sub-Sections'
			)
		)
	);



	return $meta_boxes;

}
add_filter( 'cmb_meta_boxes', 'cmb_sample_metaboxes' );
