<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<?php   global $smof_data; ?>
<meta charset="<?php bloginfo('charset'); ?>">
<title><?php echo bloginfo('name').wp_title(); ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="description" content="<?php echo get_bloginfo('description'); ?>"/>
<meta name="keywords" content="<?php bloginfo('categories'); ?>"/>

<?php if($smof_data['favicon'] != '') { ?>
<link rel="shortcut icon" href="<?php echo $smof_data['favicon']; ?>">
<?php } else {?>
<link rel="shortcut icon" href="<?php get_stylesheet_directory_uri(); ?>assets/ico/favicon.ico">
<?php } ?>
<!-- Standard iPhone Touch Icon--> 
<link rel="apple-touch-icon" sizes="57x57" href="<?php get_stylesheet_directory_uri(); ?>/assets/ico/apple-touch-icon-57-precomposed" />
<!-- Retina iPhone Touch Icon--> 
<link rel="apple-touch-icon" sizes="114x114" href="<?php get_stylesheet_directory_uri(); ?>/assets/ico/apple-touch-icon-114-precomposed" />
<!-- Standard iPad Touch Icon--> 
<link rel="apple-touch-icon" sizes="72x72" href="<?php get_stylesheet_directory_uri(); ?>/assets/ico/apple-touch-icon-72-precomposed" />
<!-- Retina iPad Touch Icon--> 
<link rel="apple-touch-icon" sizes="144x144" href="<?php get_stylesheet_directory_uri(); ?>/assets/ico/apple-touch-icon-144-precomposed" />


<!--[if lt IE 9]>
  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->
<?php wp_head();  ?>
</head>

<body id="body" <?php body_class(); ?>>
<!-- Preloader -->
<div id="preloader">
  <div id="status">&nbsp;</div>
</div>


<!-- Mobile And Desktop Navigation Function: Function defenitions are in functions.php -->
<?php
    next_custom_mobile_menu($title = get_bloginfo('name'));
    //Desktop Menus
    if(isset($smof_data['menu_type'])):
		$next_m_type = $smof_data['menu_type'];
		if($next_m_type == 1)
		{
			next_custom_icon_menu(); 
			echo '<div id="logo" class="hidden-xs"><img alt="" title="" src="'.$smof_data['mainlogo'] .'"/></div>';
		}
		else
		{
			next_custom_text_menu($image = $smof_data['mainlogo'] ); 
		}
	endif;	



?>
<section id="mastwrap" class="sliding">