<?php

add_action('init','of_options');

if (!function_exists('of_options'))
{
	function of_options()
	{
		//Access the WordPress Categories via an Array
		$of_categories 		= array();  
		$of_categories_obj 	= get_categories('hide_empty=0');
		foreach ($of_categories_obj as $of_cat) {
		    $of_categories[$of_cat->cat_ID] = $of_cat->cat_name;}
		$categories_tmp 	= array_unshift($of_categories, "Select a category:");    
	       
		//Access the WordPress Pages via an Array
		$of_pages 			= array();
		$of_pages_obj 		= get_pages('sort_column=post_parent,menu_order');    
		foreach ($of_pages_obj as $of_page) {
		    $of_pages[$of_page->ID] = $of_page->post_name; }
		$of_pages_tmp 		= array_unshift($of_pages, "Select a page:");       
	
		//Testing 
		$of_options_select 	= array("one","two","three","four","five"); 
		$of_options_radio 	= array("one" => "One","two" => "Two","three" => "Three","four" => "Four","five" => "Five");
		
		//Sample Homepage blocks for the layout manager (sorter)
		$of_options_homepage_blocks = array
		( 
			"disabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_one"		=> "Block One",
				"block_two"		=> "Block Two",
				"block_three"	=> "Block Three",
			), 
			"enabled" => array (
				"placebo" 		=> "placebo", //REQUIRED!
				"block_four"	=> "Block Four",
			),
		);


		//Stylesheets Reader
		$alt_stylesheet_path = LAYOUT_PATH;
		$alt_stylesheets = array();
		
		if ( is_dir($alt_stylesheet_path) ) 
		{
		    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) 
		    { 
		        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) 
		        {
		            if(stristr($alt_stylesheet_file, ".css") !== false)
		            {
		                $alt_stylesheets[] = $alt_stylesheet_file;
		            }
		        }    
		    }
		}


		//Background Images Reader
		$bg_images_path = get_stylesheet_directory(). '/images/slants/thumb/'; // change this to where you store your bg images
		$bg_images_url = get_template_directory_uri().'/images/slants/'; // change this to where you store your bg images
		$bg_images = array();
		
		if ( is_dir($bg_images_path) ) {
		    if ($bg_images_dir = opendir($bg_images_path) ) { 
		        while ( ($bg_images_file = readdir($bg_images_dir)) !== false ) {
		            if(stristr($bg_images_file, ".png") !== false || stristr($bg_images_file, ".jpg") !== false) {
		                $bg_images[] = $bg_images_url . $bg_images_file;
		            }
		        }    
		    }
		}
		

		/*-----------------------------------------------------------------------------------*/
		/* TO DO: Add options/functions that use these */
		/*-----------------------------------------------------------------------------------*/
		
		//More Options
		$uploads_arr 		= wp_upload_dir();
		$all_uploads_path 	= $uploads_arr['path'];
		$all_uploads 		= get_option('of_uploads');
		$other_entries 		= array("Select a number:","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19");
		$body_repeat 		= array("no-repeat","repeat-x","repeat-y","repeat");
		$body_pos 			= array("top left","top center","top right","center left","center center","center right","bottom left","bottom center","bottom right");
		
		// Image Alignment radio box
		$of_options_thumb_align = array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"); 
		
		// Image Links to Options
		$of_options_image_link_to = array("image" => "The Image","post" => "The Post"); 


/*-----------------------------------------------------------------------------------*/
/* The Options Array */
/*-----------------------------------------------------------------------------------*/

// Set the Options Array
global $of_options;
$of_options = array();

/*-----------------------------------------------------------------*/
/*----Basic Screen----*/
/*-----------------------------------------------------------------*/				
$of_options[] = array( "name" => "Basic Settings",
					"type" => "heading");
										
$of_options[] = array("name" => "Logo",
					"desc" => "This logo will appear on the top menu while the menu toggele is open",
					"id"   => "mainlogo",
					"std"  => "",
					"mod"  => "min",
					"type" => "media");

$of_options[] = array("name" => "Logo @2x",
					"desc" => "Logo for HiDPI/Retina Ready Devices Like Smartphones",
					"id"   => "retinalogo",
					"std"  => "",
					"mod"  => "min",
					"type" => "media");

$of_options[] = array("name" => "Footer Logo",
					"desc" => "Footer logo",
					"id"   => "footerlogo",
					"std"  => "",
					"mod"  => "min",
					"type" => "media");

$of_options[] = array("name" => "Footer Logo @2x",
					"desc" => "Logo for HiDPI/Retina Ready Devices Like Smartphones",
					"id"   => "ftretinalogo",
					"std"  => "",
					"mod"  => "min",
					"type" => "media");

$of_options[] = array( "name"=> "Footer Tagline",
					"desc"   => "Tagline text appears below the footer logo",
					"id"     => "footer_tagline",
					"std"    => "Built by Designova",
					"type"   => "text"); 

$of_options[] = array( "name"=> "Copyright",
					"desc"   => "Copyright text",
					"id"     => "footer_copyright",
					"std"    => "Copyright &copy; 2013.<br/> All rights reserved",
					"type"   => "text"); 

$of_options[] = array( "name" => "Favicon",
					"desc" => "Website Favicon",
					"id" => "favicon",
					"std" => "",
					"mod" 		=> "min",
					"type" => "media");	
/*-----------------------------------------------------------------*/
/*----Appearance----*/
/*-----------------------------------------------------------------*/
$of_options[] = array( "name" => "Appearance Settings",
					   "type" => "heading");

$of_options[] = array( 	"name" 		=> "Splash Page BG Mode",
						"desc" 		=> "Select the splash page background style",
						"id" 		=> "splash_bg_mode",
						"std" 		=> 1,
						"on" 		=> "Image",
						"off" 		=> "Slider",
						"folds"		=> 1,						
						"type" 		=> "switch"
				);  

$of_options[] = array( "name"    => "Splash Page Background - Image",
						"desc"   => "Background Image for Splash Page",
						"id"     => "bg_splash",
						"std"    => "",
					    "mod"    => "min",						
						"type"   => "media");

$of_options[] = array( "name"    => "Splash Page Background - Slider",
						"desc"   => "Background Image for Splash Page",
						"id"     => "bg_splash_slider",
						"std"    => "",
					    "mod"    => "min",						
						"type"   => "slider");					

$of_options[] = array( 	"name" 		=> "Menu Style",
						"desc" 		=> "Select the menu style",
						"id" 		=> "menu_type",
						"std" 		=> 1,
						"on" 		=> "Side Menu",
						"off" 		=> "Top Menu",
						"folds"		=> 1,						
						"type" 		=> "switch"
				);  

$of_options[] = array( 	"name" 		=> "Side Menu Auto Hide In Splash Page",
						"desc" 		=> "If checked Menu will be hidden on splash page.",
						"id" 		=> "menu_hidden",
						"std" 		=> 1,
						"type" 		=> "checkbox",
						"fold" 		=> "menu_type", /* the switch hook */
				);


$of_options[] = array( "name" => "Custom CSS",
                    "desc" => "Quickly add some CSS to your theme by adding it to this block.",
                    "id" => "custom_css",
                    "std" => "",
                    "type" => "textarea");

/*-----------------------------------------------------------------*/
/*----Social Media ----*/
/*-----------------------------------------------------------------*/
$of_options[] = array( "name" => "Social Media",
					   "type" => "heading");

$of_options[] = array( "name" => "Hello there!",
					"desc" => "",
					"id" => "introduction",
					"std" => "Leave unwanted fields blank so as they will not appear on live website. Excluding RSS feed, you just need to add your id only",
					"icon" => true,
					"type" => "info");

$of_options[] = array( "name"    => "Facebook",
						"desc"   => "Facebook profile id",
						"id"     => "facebook",
						"std"    => "facebook",
						"type"   => "text");

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Show on footer",
						"id" 		=> "ft_switch_fb",
						"std" 		=> 1,
						"on" 		=> "Show",
						"off" 		=> "Hide",						
						"type" 		=> "switch"
				);   

$of_options[] = array( "name"    => "Twitter",
						"desc"   => "Twitter profile id",
						"id"     => "twitter",
						"std"    => "designovastudio",
						"type"   => "text");

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Show on footer",
						"id" 		=> "ft_switch_tw",
						"std" 		=> 1,
						"on" 		=> "Show",
						"off" 		=> "Hide",						
						"type" 		=> "switch"
				);  

$of_options[] = array( "name"    => "LinedIn",
						"desc"   => "LinikedIn profile id",
						"id"     => "linkedin",
						"std"    => "",
						"type"   => "text");

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Show on footer",
						"id" 		=> "ft_switch_li",
						"std" 		=> 0,
						"on" 		=> "Show",
						"off" 		=> "Hide",						
						"type" 		=> "switch"
				);  

$of_options[] = array( "name"    => "Pintrest",
						"desc"   => "Pintrest profile id",
						"id"     => "pintrest",
						"std"    => "designova",
						"type"   => "text");

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Show on footer",
						"id" 		=> "ft_switch_pi",
						"std" 		=> 0,
						"on" 		=> "Show",
						"off" 		=> "Hide",						
						"type" 		=> "switch"
				);  
$of_options[] = array( "name"    => "googleplus",
						"desc"   => "Google Plus profile id",
						"id"     => "googleplus",
						"std"    => "designova",
						"type"   => "text");

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Show on footer",
						"id" 		=> "ft_switch_gp",
						"std" 		=> 0,
						"on" 		=> "Show",
						"off" 		=> "Hide",						
						"type" 		=> "switch"
				);  
$of_options[] = array( "name"    => "dribbble",
						"desc"   => "Dribbble  profile id",
						"id"     => "dribbble",
						"std"    => "designova",
						"type"   => "text");

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Show on footer",
						"id" 		=> "ft_switch_dr",
						"std" 		=> 0,
						"on" 		=> "Show",
						"off" 		=> "Hide",						
						"type" 		=> "switch"
				);  

$of_options[] = array( "name"    => "RSS Feed",
						"desc"   => "RSS Feed link - You need to specify the full link ",
						"id"     => "rss",
						"std"    => "designova",
						"type"   => "text");

$of_options[] = array( 	"name" 		=> "",
						"desc" 		=> "Show on footer",
						"id" 		=> "ft_switch_rs",
						"std" 		=> 0,
						"on" 		=> "Show",
						"off" 		=> "Hide",						
						"type" 		=> "switch"
				);  
/*-----------------------------------------------------------------*/
/*----Contact form ----*/
/*-----------------------------------------------------------------*/
$of_options[] = array( "name" => "Contact Form",
					"type" => "heading");
										
$of_options[] = array( "name" => "Contact Form Email",
					"desc" => "Contact form data will be mailed to this email",
					"id" => "contact_email",
					"std" => "",
					"type" => "text");
					
$of_options[] = array( "name" => "Contact form Subject",
					"desc" => "Insert HTML contents to appear on splash page here",
					"id" => "contact_subject",
					"std" => "Contact through website ",
					"type" => "text"); 

$of_options[] = array( "name" => "Name Label",
					"desc" => "Label for name, replace with your own language",
					"id" => "label_name",
					"std" => "Name",
					"type" => "text");

$of_options[] = array( "name" => "Email Label",
					"desc" => "Label for email, replace with your own language",
					"id" => "label_email",
					"std" => "Email",
					"type" => "text");

$of_options[] = array( "name" => "Message Label",
					"desc" => "Label for email, replace with your own language",
					"id" => "label_message",
					"std" => "Message",
					"type" => "text");

$of_options[] = array( "name" => "Success Message",
					"desc" => "On Successful submission",
					"id" => "msg_success",
					"std" => "Message sent successfully!",
					"type" => "text");

$of_options[] = array( "name" => "Failure Message",
					"desc" => "On Successful submission",
					"id" => "msg_fail",
					"std" => "Oops! Something went wrong try again!",
					"type" => "text");
// Backup Options
$of_options[] = array( 	"name" 		=> "Backup Options",
						"type" 		=> "heading",
						"icon"		=> ADMIN_IMAGES . "icon-slider.png"
				);
				
$of_options[] = array( 	"name" 		=> "Backup and Restore Options",
						"id" 		=> "of_backup",
						"std" 		=> "",
						"type" 		=> "backup",
						"desc" 		=> 'You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.',
				);
				
$of_options[] = array( 	"name" 		=> "Transfer Theme Options Data",
						"id" 		=> "of_transfer",
						"std" 		=> "",
						"type" 		=> "transfer",
						"desc" 		=> 'You can tranfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click "Import Options".',
				);
				
	}//End function: of_options()
}//End chack if function exists: of_options()
?>
