(function ()
{
	// create zillaShortcodes plugin
	tinymce.create("tinymce.plugins.zillaShortcodes",
	{
		init: function ( ed, url )
		{
			ed.addCommand("zillaPopup", function ( a, params )
			{
				var popup = params.identifier;
				
				// load thickbox
				tb_show("Insert SAGA Shortcode", url + "/popup.php?popup=" + popup + "&width=" + 800);
			});
		},
		createControl: function ( btn, e )
		{
			if ( btn == "zilla_button" )
			{	
				var a = this;
				
				var btn = e.createSplitButton('zilla_button', {
                    title: "Insert SAGA Shortcode",
					image: ZillaShortcodes.plugin_folder +"/tinymce/images/icon.png",
					icons: false
                });

                btn.onRenderMenu.add(function (c, b)
				{	
					a.addWithPopup( b, "Metro Tiles","metro_tiles" );			
					a.addWithPopup( b, "Flip Text","flip_text" );			
					a.addWithPopup( b, "Row","row" );			
					a.addWithPopup( b, "Columns","column" );			
					a.addWithPopup( b, "Large Text","large_text" );			
					a.addWithPopup( b, "Heading With Bg","bg_heading" );				
					a.addWithPopup( b, "Dark Button","dark_button" );			
					a.addWithPopup( b, "Hollow Button","hollow_button" );			
					a.addWithPopup( b, "Portfolio","portfolio" );			
					a.addWithPopup( b, "Services Grid","services_grid" );			
					a.addWithPopup( b, "Flicker Feed","flickr_feed" );			
					a.addWithPopup( b, "Twitter Feed","twitter_feed" );			
					a.addWithPopup( b, "Team","team_member" );			
					a.addWithPopup( b, "Skill Pie Chart","skill_chart" );			
					a.addWithPopup( b, "Testimonials","testimonials" );			
					a.addWithPopup( b, "Highlights Linker","higlights_linker" );			
					a.addWithPopup( b, "Contact Form","contact_form" );			
					a.addWithPopup( b, "Social Icons Block","social_icons" );			

				});
                
                return btn;
			}
			
			return null;
		},
		addWithPopup: function ( ed, title, id ) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand("zillaPopup", false, {
						title: title,
						identifier: id
					})
				}
			})
		},
		addImmediate: function ( ed, title, sc) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand( "mceInsertContent", false, sc )
				}
			})
		},
		getInfo: function () {
			return {
				longname: 'Designova Saga Shortcodes',
				author: 'Designova',
				authorurl: 'http://designova.net/',
				infourl: '',
				version: "1.0"
			}
		}
	});
	
	// add zillaShortcodes plugin
	tinymce.PluginManager.add("zillaShortcodes", tinymce.plugins.zillaShortcodes);
})();