<?php
/*-----------------------------------------------------------------------------------*/
/*	Rows
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['row'] = array(
    'params' => array(),
    'no_preview' => true,
    'popup_title' => __('Insert Row Shortcode', 'nextlang'),
    'params' => array(
            'id' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('ID', 'nextlang'),
                'desc' => __('', 'nextlang'),
            ),         	
            'customclass' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Custom Classes', 'nextlang'),
                'desc' => __('Use space between multiple classes', 'nextlang'),
            ),
			'fx' => array(
				'type' => 'select',
				'label' => __('Apparance Animation', 'nextlang'),
				'desc' => __('', 'nextlang'),
				'options' => array(
					'None' => '',
					'fx-bounce' => 'fx-bounce',
					'fx-flash' => 'fx-flash',
					'fx-pulse' => 'fx-pulse',
					'fx-shake' => 'fx-shake',
					'fx-swing' => 'fx-swing',
					'fx-tada' => 'fx-tada',
					'fx-wobble' => 'fx-wobble',
					'fx-bounceIn' => 'fx-bounceIn',
					'fx-bounceInDown' => 'fx-bounceInDown',
					'fx-bounceInLeft' => 'fx-bounceInLeft',
					'fx-bounceInRight' => 'fx-bounceInRight',
					'fx-bounceInUp' => 'fx-bounceInUp',
					'fx-bounceOut' => 'fx-bounceOut',
					'fx-bounceOutDown' => 'fx-bounceOutDown',
					'fx-bounceOutLeft' => 'fx-bounceOutLeft',
					'fx-bounceOutRight' => 'fx-bounceOutRight',
					'fx-bounceOutUp' => 'fx-bounceOutUp',
					'fx-fadeIn' => 'fx-fadeIn',
					'fx-fadeInDown' => 'fx-fadeInDown',
					'fx-fadeInDownBig' => 'fx-fadeInDownBig',
					'fx-fadeInLeft' => 'fx-fadeInLeft',
					'fx-fadeInLeftBig' => 'fx-fadeInLeftBig',
					'fx-fadeInRight' => 'fx-fadeInRight',
					'fx-fadeInRightBig' => 'fx-fadeInRightBig',
					'fx-fadeInUp' => 'fx-fadeInUp',
					'fx-fadeInUpBig' => 'fx-fadeInUpBig',
					'fx-flip' => 'fx-flip',
					'fx-flipInX' => 'fx-flipInX',
					'fx-flipInY' => 'fx-flipInY',				
					'fx-lightSpeedIn' => 'fx-lightSpeedIn',
					'fx-rotateIn' => 'fx-rotateIn',
					'fx-rotateInDownLeft' => 'fx-rotateInDownLeft',
					'fx-rotateInDownRight' => 'fx-rotateInDownRight',
					'fx-rotateInUpLeft' => 'fx-rotateInUpLeft',
					'fx-rotateInUpRight' => 'fx-rotateInUpRight',
					'fx-slideInDown' => 'fx-slideInDown',
					'fx-slideInLeft' => 'fx-slideInLeft',
					'fx-slideInRight' => 'fx-slideInRight'
				)
			),

            'content' => array(
                'std' => 'Use Column Shortcodes Here',
                'type' => 'text',
                'label' => __('Row Content', 'nextlang'),
                'desc' => __('Add row content', 'nextlang')
            ),
        ),
        'shortcode' => '[row id="{{id}}" fx="{{fx}}" customclass="{{customclass}}"] {{content}} [/row]',
        'clone_button' => __('Add Row', 'nextlang')
);

/*-----------------------------------------------------------------------------------*/
/*	Mega Accordion
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['metro_tiles'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[metro_tiles]',
    'popup_title' => __('Metro Tiles Post Type Output', 'nextlang'),
);

/*-----------------------------------------------------------------------------------*/
/*	Flip Text
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['flip_text'] = array(
    'params' => array(),
    'no_preview' => true,
    'popup_title' => __('Flip Text', 'nextlang'),
    'params' => array(
            'title'=> array(
                'std'   => '',
                'type'  => 'text',
                'label' => __('Title', 'nextlang'),
                'desc'  => __('Title/Label', 'nextlang'),
            ),    	
            'link' => array(
                'std' => '#',
                'type' => 'text',
                'label' => __('Link', 'nextlang'),
                'desc' => __('Absolute path to image: http://domain.tld/path/to/img.ext', 'nextlang'),
            ),
            'link_title' => array(
                'std' => 'Explore More',
                'type' => 'text',
                'label' => __('Link Label', 'nextlang'),
                'desc' => __('Link label', 'nextlang'),
            ),            
 
            'flipcontent' => array(
                'std' => 'one, two, three',
                'type' => 'textarea',
                'label' => __('Flip Content', 'nextlang'),
                'desc' => __('Use comma between words/sentences', 'nextlang'),
            ),                       
            
        ),
    'shortcode' => '[container][row][column span="12"][splashwrapper][splash_h3 background="" textcolor="#fff"]{{title}}[/splash_h3][fliptext uid="fs1" effect="flipCube"]{{flipcontent}}}[/fliptext][/splashwrapper][/column][/row][row customclass="add-top"][column span="12" customclass="text-center"][hollowbutton url="{{link}}" title="{{link_title}}"][/column][/row][/container]',

);



/*-----------------------------------------------------------------------------------*/
/*	Portfolio
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['portfolio'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[portfolio]',
    'popup_title' => __('Portfolio Shortcode - Portfolio Post Type Output', 'nextlang'),
);
/*-----------------------------------------------------------------------------------*/
/*	Services Grid
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['services_grid'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[services_grid categories="{{categories}}"]',
    'params' => array(    
            'categories' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Categories', 'nextlang'),
                'desc' => __('Use comma sperated slug values for multiple categories', 'nextlang'),
            ),
                              
            
        ),    
    'popup_title' => __('Services Grid', 'nextlang'),
    
);
/*-----------------------------------------------------------------------------------*/
/*	twit
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['twitter_feed'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[twitterfeed]',
    'popup_title' => __('Twitter Feed', 'nextlang'),
    
);
/*-----------------------------------------------------------------------------------*/
/*	Twif
/*-----------------------------------------------------------------------------------*/

$zilla_shortcodes['flickr_feed'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[flicker unique_id="{{unique_id}}" photoset_id="{{photoset_id}}"]',
    'params' => array(
            'unique_id'=> array(
                'std'   => '',
                'type'  => 'text',
                'label' => __('Unique ID', 'nextlang'),
                'desc'  => __('', 'nextlang'),
            ),    	
            'photoset_id' => array(
                'std' => '#',
                'type' => 'text',
                'label' => __('Flickr Photoset ID', 'nextlang'),
                'desc' => __('Flickr Photoset ID', 'nextlang'),
            ),
                              
            
        ),    
    'popup_title' => __('Flickr Photoset', 'nextlang'),
    
);
/*-----------------------------------------------------------------------------------*/
/*	Column
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['column'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[column span="{{span}}" mobile="{{mobile}}" id="{{id}}" fx="{{fx}}" customclass="{{customclass}}"  ] {{content}} [/column]',
    'popup_title' => __('Insert Column Shortcode', 'nextlang'),
    'params' => array(
            'span' => array(
                'std' => '4',
                'type' => 'select',
                'options' => array(
					'1' => '1',
					'2' => '2',		
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
					'7' => '7',
					'8' => '8',
					'9' => '9',
					'10' => '10',
					'11' => '11',
					'12' => '12',					
				),
                'label' => __('Columns', 'nextlang'),
                'desc' => __('Number of Columns', 'nextlang'),
            ), 
            'mobile' => array(
                'std' => '',
                 'type' => 'select',
                'options' => array(
					'1' => '1',
					'2' => '2',		
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
					'7' => '7',
					'8' => '8',
					'9' => '9',
					'10' => '10',
					'11' => '11',
					'12' => '12',					
				),
                'label' => __('Mobile Columns', 'nextlang'),
                'desc' => __('Number of Columns in mobile', 'nextlang'),
            ),                    	
            'id' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('ID', 'nextlang'),
                'desc' => __('', 'nextlang'),
            ),         	
            'customclass' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Custom Classes', 'nextlang'),
                'desc' => __('Use space between multiple classes', 'nextlang'),
            ),
			'fx' => array(
				'type' => 'select',
				'label' => __('Apparance Animation', 'nextlang'),
				'desc' => __('', 'nextlang'),
				'options' => array(
					'None' => '',
					'fx-bounce' => 'fx-bounce',
					'fx-flash' => 'fx-flash',
					'fx-pulse' => 'fx-pulse',
					'fx-shake' => 'fx-shake',
					'fx-swing' => 'fx-swing',
					'fx-tada' => 'fx-tada',
					'fx-wobble' => 'fx-wobble',
					'fx-bounceIn' => 'fx-bounceIn',
					'fx-bounceInDown' => 'fx-bounceInDown',
					'fx-bounceInLeft' => 'fx-bounceInLeft',
					'fx-bounceInRight' => 'fx-bounceInRight',
					'fx-bounceInUp' => 'fx-bounceInUp',
					'fx-bounceOut' => 'fx-bounceOut',
					'fx-bounceOutDown' => 'fx-bounceOutDown',
					'fx-bounceOutLeft' => 'fx-bounceOutLeft',
					'fx-bounceOutRight' => 'fx-bounceOutRight',
					'fx-bounceOutUp' => 'fx-bounceOutUp',
					'fx-fadeIn' => 'fx-fadeIn',
					'fx-fadeInDown' => 'fx-fadeInDown',
					'fx-fadeInDownBig' => 'fx-fadeInDownBig',
					'fx-fadeInLeft' => 'fx-fadeInLeft',
					'fx-fadeInLeftBig' => 'fx-fadeInLeftBig',
					'fx-fadeInRight' => 'fx-fadeInRight',
					'fx-fadeInRightBig' => 'fx-fadeInRightBig',
					'fx-fadeInUp' => 'fx-fadeInUp',
					'fx-fadeInUpBig' => 'fx-fadeInUpBig',
					'fx-flip' => 'fx-flip',
					'fx-flipInX' => 'fx-flipInX',
					'fx-flipInY' => 'fx-flipInY',				
					'fx-lightSpeedIn' => 'fx-lightSpeedIn',
					'fx-rotateIn' => 'fx-rotateIn',
					'fx-rotateInDownLeft' => 'fx-rotateInDownLeft',
					'fx-rotateInDownRight' => 'fx-rotateInDownRight',
					'fx-rotateInUpLeft' => 'fx-rotateInUpLeft',
					'fx-rotateInUpRight' => 'fx-rotateInUpRight',
					'fx-slideInDown' => 'fx-slideInDown',
					'fx-slideInLeft' => 'fx-slideInLeft',
					'fx-slideInRight' => 'fx-slideInRight'
				)
			),

            'content' => array(
                'std' => 'Use Wordpress Editor',
                'type' => 'text',
                'label' => __('Column Content', 'nextlang'),
                'desc' => __('', 'nextlang')
            ),
        ),

    
);
/*-----------------------------------------------------------------------------------*/
/*	Promo Text
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['large_text'] = array(
    'params' => array(),
    'no_preview' => true,
    'popup_title' => __('Insert Large Text', 'nextlang'),
    'params' => array(
            'color' => array(
                'std' => '#596A6D',
                'type' => 'text',
                'label' => __('Color', 'nextlang'),
                'desc' => __('Use HEX code: Ex: #444', 'nextlang'),
            ),


            'content' => array(
                'std' => 'Promotext Content',
                'type' => 'textarea',
                'label' => __('Large Text Content', 'nextlang'),
                'desc' => __('Add  content', 'nextlang')
            ),
        ),
        'shortcode' => '[welcometext color="{{color}}"]{{content}}[/welcometext]',
);

/*-----------------------------------------------------------------------------------*/
/*	Team Member
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['team_member'] = array(
    'params'     => array(),
    'no_preview' => true,
    'popup_title'=> __('Add a Team Member', 'nextlang'),
    'desc'       => __('Do not add more than three members in a row', 'nextlang'),
    'shortcode'  => '{{child_shortcode}}', // as there is no wrapper shortcode
	'child_shortcode' => array( 
        'params' => array(
            'name' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Name', 'nextlang'),
                'desc' => __('Member name', 'nextlang'),
            ),    	
            'photo'=> array(
                'std'   => '',
                'type'  => 'text',
                'label' => __('Photo', 'nextlang'),
                'desc'  => __('Absolute path to image: http://domain.tld/path/to/img.ext', 'nextlang'),
            ),
            'link'=> array(
                'std'   => '#',
                'type'  => 'text',
                'label' => __('Link Memeber Image', 'nextlang'),
                'desc'  => __('Absolute URL to link image', 'nextlang'),
            ),                
            'designation' => array(
                'std'     => '',
                'type'    => 'text',
                'label'   => __('Designation', 'nextlang'),
                'desc'    => __('Member Designation', 'nextlang')
            ),
            'bg'      => array(
                'std'     => '',
                'type'    => 'text',
                'label'   => __('Background Color', 'nextlang'),
                'desc'    => __('Prefer dark colors', 'nextlang')
            )
           
        ),
        'shortcode' => '[team_member name="{{name}}" bg_color="{{bg}}" photo="{{photo}}" designation="{{designation}}"  link="{{link}}"]',
        'clone_button' => __('Add Team Member', 'nextlang')
        ),

);

/*-----------------------------------------------------------------------------------*/
/*	Team Member
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['higlights_linker'] = array(
    'params' => array(),
    'no_preview' => true,
    'popup_title' => __('Add a Highlight', 'nextlang'),
    'desc' => __('', 'nextlang'),
    'shortcode' => '[highlights_wrapper]{{child_shortcode}}[/highlights_wrapper]', // as there is no wrapper shortcode
	'child_shortcode' => array( 
       'params' => array(
            'title' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Title', 'nextlang'),
                'desc' => __('', 'nextlang'),
            ),    	
            'color'=> array(
                'std'   => '#04B8E0',
                'type'  => 'text',
                'label' => __('Background Color', 'nextlang'),
                'desc'  => __('Absolute path to image: http://domain.tld/path/to/img.ext', 'nextlang'),
            ),
            'link'=> array(
                'std'   => '#',
                'type'  => 'text',
                'label' => __('Link', 'nextlang'),
                'desc'  => __('', 'nextlang'),
            ),                
           
           
        ),
        'shortcode' => '[highlight title="{{title}}" color="{{title}}" link="#"]',
        'clone_button' => __('Add New Highlight', 'nextlang')
        ),

);

/*-----------------------------------------------------------------------------------*/
/*	Sub-Heading
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['bg_heading'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[bgcolor_heading background="{{bg}}" textcolor="{{color}}" hmod="{{hmod}}"] {{content}} [/bgcolor_heading]',
    'popup_title' => __('BG Color Heading', 'nextlang'),
    'params' => array(
            'hmod' => array(
                'std' => 'h3',
                'type' => 'select',
                'options' => array(
					'h1' => 'h1',
					'h2' => 'h2',		
					'h3' => 'h3',
					'h4' => 'h4',
					'h5' => 'h5',
					'h6' => 'h6',			
				),
                'label' => __('Heading Style', 'nextlang'),
                'desc' => __('H1 to H6', 'nextlang'),
            ),    
            'bg' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Background Color', 'nextlang'),
                'desc' => __('Use HEX color values Ex:#000000', 'nextlang'),
            ),                             	
            'color' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Text Color', 'nextlang'),
                'desc' => __('Use HEX color values Ex:#000000', 'nextlang'),
            ),         	
            'content' => array(
                'std' => 'Heading Text',
                'type' => 'text',
                'label' => __('Heading Text', 'nextlang'),
                'desc' => __('', 'nextlang')
            ),
        ),
    
);


/*-----------------------------------------------------------------------------------*/
/*	Testimonial Carousel
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['testimonials'] = array(
    'params' => array(),
    'no_preview' => true,
    'popup_title' => __('Testimonials', 'nextlang'),
    'shortcode' => '[testimonials_wrapper]{{child_shortcode}}[/testimonials_wrapper]',
    'child_shortcode' => array(
        'params' => array(
           'text_color' => array(
                'std' => '#fff',
                'type' => 'text',
                'label' => __('Text Color', 'nextlang'),
                'desc' => __('Use HEX color Ex:#000000', 'nextlang')
            ),
            'author' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Author', 'nextlang'),
                'desc' => __('Testimonial author', 'nextlang')
            ),  
            'image' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Photo', 'nextlang'),
                'desc' => __('Use absolute link to image', 'nextlang')
            ),                             
            'content' => array(
                'std' => '',
                'type' => 'textarea',
                'label' => __('Content', 'nextlang'),
                'desc' => __('', 'nextlang')
            )            
        ),
        'shortcode' => '[testimonial author="{{author}}" image="{{image}}" text_color="{{text_color}}"]{{content}}[/testimonial]',
        'clone_button' => __('Add New Testimonial', 'nextlang')
    ),
);

/*-----------------------------------------------------------------------------------*/
/*	Contact Form
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['contact_form'] = array(
    'params' => array(),
    'no_preview' => true,
    'popup_title' => __('Contact Form Shortcode', 'nextlang'),
    'shortcode' => '[contactform]',
);
/*-----------------------------------------------------------------------------------*/
/*	Next Button
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['hollow_button'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[hollowbutton  title="{{title}}" url="{{url}}"]',
    'popup_title' => __('Button', 'nextlang'),
    'params' => array(
            'title' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Button Label', 'nextlang'),
                'desc' => __('', 'nextlang'),
            ),         	
            'url' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('URL', 'nextlang'),
                'desc' => __('Default - #', 'nextlang'),
            ),
            
        ),
    
);

/*-----------------------------------------------------------------------------------*/
/*	Next Button
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['dark_button'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[next_dark_button  label="{{label}}" link="{{link}} class="{{class}}"]',
    'popup_title' => __('Button', 'nextlang'),
    'params' => array(
            'label' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Button Label', 'nextlang'),
                'desc' => __('', 'nextlang'),
            ),         	
            'link' => array(
                'std' => '#',
                'type' => 'text',
                'label' => __('URL', 'nextlang'),
                'desc' => __('Default - #', 'nextlang'),
            ),
            'class' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Custom Class', 'nextlang'),
                'desc' => __('', 'nextlang'),
            ),            
        ),
    
);
/*-----------------------------------------------------------------------------------*/
/*	Next Button
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['skill_chart'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[skill uid="c{{id}}" size="64" color="#C2CE1A"]{{title}}[/skill]',
    'popup_title' => __('Button', 'nextlang'),
    'params' => array(
            'id' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Unique ID', 'nextlang'),
                'desc' => __('', 'nextlang'),
            ),         	
            'size' => array(
                'std' => '60',
                'type' => 'text',
                'label' => __('URL', 'nextlang'),
                'desc' => __('1 - 100', 'nextlang'),
            ),
            'skillbase' => array(
                'std' => '%',
                'type' => 'text',
                'label' => __('Skill Base', 'nextlang'),
                'desc' => __('Ex: %', 'nextlang'),
            ),            
            'color' => array(
                'std' => '#C2CE1A',
                'type' => 'text',
                'label' => __('Color', 'nextlang'),
                'desc' => __('Positive area color', 'nextlang'),
            ),   
            'title' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Title', 'nextlang'),
                'desc' => __('', 'nextlang')
            )                       
        ),
    
);
/*-----------------------------------------------------------------------------------*/
/*	Social Icons
/*-----------------------------------------------------------------------------------*/
$zilla_shortcodes['social_icons'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[socialicons span="12" email="{{email}}}" mobile="{{mobile}}" twitter="{{twitter}}" dribbble="{{dribbble}}"]',
    'popup_title' => __('Button', 'nextlang'),
    'params' => array(
            'email' => array(
                'std' => 'mailto:name@dmain.tld',
                'type' => 'text',
                'label' => __('Unique ID', 'nextlang'),
                'desc' => __('Span width', 'nextlang'),
            ),         	
            'mobile' => array(
                'std' => '#',
                'type' => 'text',
                'label' => __('URL', 'nextlang'),
                'desc' => __('', 'nextlang'),
            ),
            'twitter' => array(
                'std' => '#',
                'type' => 'text',
                'label' => __('Twitter', 'nextlang'),
                'desc' => __('Id', 'nextlang'),
            ),            
            'dribbble' => array(
                'std' => '#',
                'type' => 'text',
                'label' => __('Dribbble', 'nextlang'),
                'desc' => __('Dribbble id', 'nextlang'),
            ),                                
        ),
    
);