<?php

/*-------------------------------------
 Portfolio 
--------------------------------------*/
if (!function_exists('portfolio')) 
{
    function portfolio($atts, $content = null)
      {
         global $post;
    //The filter segment
        $categories = get_categories(array('type' => 'portfolio_item', 'taxonomy' => 'portfolio_category'));
         

        $html = '<div class="row next-bg-eleven common-pad">
              <article class="text-left ">
                <div id="item_container" class="clearfix"></div>
                 <div id="filter" class="clearfix">
                      <div id="filter_wrapper" class="controls">
                           <ul id="portfolioFilter">
                               <li class="active"><a  class="filter" data-filter="all">'.__('All','nextlang').'</a></li>';
                          foreach($categories as $category): 
                                    $categoryClass = strtolower($category->slug);   
                              $html .= '<li class="separator">/</li>
                               <li><a  class="filter" data-filter="'.$categoryClass.'">'.$category->name.'</a></li>';
                          endforeach;     
        $html .= '</ul>
                      </div>
                 </div>
              </article>
        </div>';

    //Begin the grid wrapper
        $html .= '<div class="row">

            <div class="row">
              <section id="portfolio-wrap" class="clearfix">
         <div id="portfolio_thumbs">
         
              <ul class="sortablePortfolio clearfix" id="grid">';
                                       
    /*
        Grid items goes here
      <div id="portfolio_thumbs" class="fx fx-slideInLeft">
      1. Ajax Expanded portfolio item with slier inside
         Slider Image
      2. Lightbox portfolio item
         Zoom Image

      Meta: Display Type - Expand With Data, Lightbox Only,Highlight Color

    */

    //The loop

    $loop = new WP_Query( array( 'post_type' => 'portfolio_item', 'orderby' => 'date', 'order' => 'ASC','posts_per_page' => 50,'paged'=>false ) ); 
    while ( $loop->have_posts() ) : $loop->the_post(); 
    $cate = wp_get_post_terms($post->ID, $taxonomy = 'portfolio_category'); 

    //Fetch the meta options
    $display_mode    =  get_post_meta($post->ID,'next_port_displaymode',true );
    $lb_image        =  get_post_meta($post->ID,'next_port_lightbox',true );
    $lb_youtube      =  get_post_meta($post->ID,'next_port_youtube',true );
    $port_bgcolor    =  get_post_meta($post->ID,'next_port_bgcolor',true );


    //Making compatibile for multiple grouping
    if(!empty($lb_image )):
         $lbg             = wp_get_attachment_image_src($lb_image,'full');
         $alternative_one = $lbg[0];
    else:
         $alternative_one = '';
    endif; 


    if($cate)
    {
          //Multiple categories
          $arr_cnt = count($cate) - 1;
          $slug_arr = '';
          $class_arr = '';
          for($i=0;$i<=$arr_cnt;$i++)
          {
            $slug_arr .= strtolower($cate[$i]->slug).",";
            $class_arr .= strtolower($cate[$i]->slug)." ";
          }


    //Switch the type of loading a portfolio expansion
    switch($display_mode)
    {

      case 'dataexpand':
        //Ajax Expansion Goes here
          $html .= '<li class="mix  '.$class_arr .'">';
          $html .='<a href="'.get_permalink().'" class="more_info">';            
                if(has_post_thumbnail()): 
                   $thumbnail_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), '', true, '');
                   $html .= '<img src="'.$thumbnail_img[0].'"  alt="'.get_the_title().'" class="grayscale" />';
                   $html .= '<img src="'.$thumbnail_img[0].'"  alt="'.get_the_title().'" class="rollover" />';
                else: 
                   $html .= '<img src="'.get_stylesheet_directory_uri().'/images/default-featured-image.png"  alt="'.get_the_title().'"/>';
                endif;
           $html .= '</a>
                      <div class="item_info">
                           <h3><a href="'.get_permalink().'" class="more_info"><span style="background:'.$port_bgcolor.'">'.get_the_title().'</span></a></h3>
                           <p><span>'.$class_arr.'</span></p>
                      </div>
              </li>';
      break;
      case 'lightbox':
            $html .= '<li class="mix  '.$class_arr .'" >';
            $html .= '<a href="'.$alternative_one.'" data-gal="prettyPhoto[gallery]">';
                    if(has_post_thumbnail()): 
                       $thumbnail_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), '', true, '');
                       $html .= '<img src="'.$thumbnail_img[0].'"  alt="'.get_the_title().'" class="grayscale" />';
                       $html .= '<img src="'.$thumbnail_img[0].'"  alt="'.get_the_title().'" class="rollover" />';
                    else: 
                       $html .= '<img src="'.get_stylesheet_directory_uri().'/images/default-featured-image.png"  alt="'.get_the_title().'"/>';
                    endif;
              $html .= '</a>
                      <div class="item_info">
                           <h3><a href="'.$alternative_one.'" data-gal="prettyPhoto[gallery]"><span style="background:'.$port_bgcolor.'">'.get_the_title().'</span></a></h3>
                           <p><span>'.$class_arr.'</span></p>
                      </div>
                  </li>';

      break;
      case 'lightboxyoutube':
           $html .= '<li class="mix '.$class_arr .'" >';
           $html .= '<a href="http://www.youtube.com/watch?v='.$lb_youtube.'" data-gal="prettyPhoto[gallery]">';
                      if(has_post_thumbnail()): 
                         $thumbnail_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), '', true, '');
                         $html .= '<img src="'.$thumbnail_img[0].'"  alt="'.get_the_title().'" class="grayscale" />';
                         $html .= '<img src="'.$thumbnail_img[0].'"  alt="'.get_the_title().'" class="rollover" />';
                      else: 
                         $html .= '<img src="'.get_stylesheet_directory_uri().'/images/default-featured-image.png"  alt="'.get_the_title().'"/>';
                      endif;
           $html .='</a>
                      <div class="item_info">
                           <h3><a href="http://www.youtube.com/watch?v='.$lb_youtube.'" data-gal="prettyPhoto[gallery]"><span style="background:'.$port_bgcolor.'">'.get_the_title().'</span></a></h3>
                           <p><span>'.$class_arr.'</span></p>
                      </div>
                  </li>';
      break;


    }//Switch case ends
    } //multiple cate compatiblity ends

    endwhile;  
        //Wrapper Ends                      
        $html .= ' </ul>
         </div>
             </section>  
            </div>
        </div>';
         return $html;
    }
      add_shortcode('portfolio', 'portfolio');
}
/*-------------------------------------
 Services 
--------------------------------------*/
if (!function_exists('services_grid')) 
{      

      function services_grid($atts, $content = null)
        {
      extract(shortcode_atts(array( "categories" => ''), $atts));    
      global $post;


//Category Wise Display - Added since version 2.1
    if($categories !='')
    {
      $args = array(
                  'post_type' => 'services', 
                  'orderby' => 'date', 
                  'order' => 'ASC',
                  'posts_per_page' => 300,
                  'paged'=>false,
                  'services_category' => $categories
                  );
    }
    else
    {
      $args = array(
                  'post_type' => 'services', 
                  'orderby' => 'date', 
                  'order' => 'ASC',
                  'posts_per_page' => 300,
                  'paged'=>false,
                  );      
    }


      $html = '<ul id="rb-grid" class="rb-grid clearfix">';

      $serv_loop = new WP_Query($args); 
     

      while ($serv_loop->have_posts()) : $serv_loop->the_post(); 

      $tile_width          =  get_post_meta($post->ID,'next_serv_tilewidth',true );
      $tile_color          =  get_post_meta($post->ID,'next_serv_tilecolor',true ); 
      $tile_icon           =  get_post_meta($post->ID,'next_serv_tileicon',true );
      $tile_subheading     =  get_post_meta($post->ID,'next_serv_subheading',true );
      $tile_subheading_two =  get_post_meta($post->ID,'next_serv_subheading_two',true );
      $tile_slides         =  get_post_meta($post->ID,'next_serv_sliderimages',false );

      switch($tile_width)
      {
       case '1':
        $tile_with_class = '';
       break;
       case '2':
        $tile_with_class = 'rb-span-2';
       break;
       case '4':
        $tile_with_class = 'rb-span-4';
       break;

      }

      //The main Icon
     if(!empty($tile_icon)):
         $tic         = wp_get_attachment_image_src($tile_icon,'full');
         $t_icon_path = $tic[0];
     else:
         $t_icon_path = '';
     endif; 

      $html .=  '<li class="'.$tile_with_class.'" style="background:'.$tile_color.'">';
      $html .=  '<h3>'.get_the_title().'</h3><span class="rb-temp">'.$tile_subheading.'</span>';
      //Show Icon if available
      if($t_icon_path!=''):
      $html .=   '<img alt="" title="" class="service-thumb" src="'.$t_icon_path.'"/>';
      endif;

      $html .= ' <div class="rb-overlay">
                    <span class="rb-close">close</span>';

      $html .= '  <!-- service-content : starts -->
                  <div class="rb-week clearfix" style="background:'.$tile_color.'">
                    
                    <!-- service-matter : starts -->
                    <div class="service-matter">
                        <span>'.get_the_title().'</span>';

      //Sliders
      if(!empty($tile_slides)):
      $html .= '<div id="service-carousel-01" class="carousel slide">  
                            <div class="carousel-inner">';
      $slides = count($tile_slides);
      for($i=0;$i<$slides;$i++)
        {
              if($i == 0) {$act = 'active';}else{$act = '';}
              $imurl = wp_get_attachment_image_src($tile_slides[$i],'full');
              $html .= '<div class="item '.$act.'">
                        <img alt="" title="" class="service-spec-img" src="'.$imurl[0].'"/>
                        <div class="carousel-caption"></div> </div>';
       }

      $html .=  '</div>
      </div>';
      endif; 

      $cont = get_the_content();
      $html .=    '</div>
                      <div class="service-info">
                        <h5 class="service-spec">'.$tile_subheading.'</h5>
                        <h3>'.$tile_subheading_two.'</h3>
                        <p>'.do_shortcode($cont).'</p>
                      </div>
                  </div>
                  </div>
                </li>';

      endwhile;
      $html .= '</ul>';


         return $html;
      }
            add_shortcode('services_grid', 'services_grid');
}

/*-------------------------------------
 Metro Tiles
--------------------------------------*/
if (!function_exists('metro_tiles')) 
{        
        function metro_tiles($atts, $content = null)
          {
        global $post;

        $html = '<section id="metro-panel">
              <div class="stripe clearfix">';

        $tile_loop = new WP_Query( array( 'post_type' => 'metro_tiles', 'orderby' => 'menu_order','posts_per_page' => 50,'paged'=>false ) ); 
        while ($tile_loop->have_posts()) : $tile_loop->the_post(); 

        $tile_behaviour      =  get_post_meta($post->ID,'next_metro_tilebehaviour',true );
        $tile_width          =  get_post_meta($post->ID,'next_metro_tilewidth',true );


        switch($tile_behaviour)
        {

         case 'infotile':
            //Get the meta
            $tile_bg_color          =  get_post_meta($post->ID,'next_metroit_bgcolor',true); 
            $tile_hover_color       =  get_post_meta($post->ID,'next_metroit_bghover',true); 
            $tile_icon              =  get_post_meta($post->ID,'next_metroit_icon',true);
            $tile_icon_image        =  wp_get_attachment_image_src($tile_icon,'full');
            $tile_desc              =  get_post_meta($post->ID,'next_metroit_desc',true);  
            $tile_linktext          =  get_post_meta($post->ID,'next_metroif_linktext',true); 
            $tile_link              =  get_post_meta($post->ID,'next_metroit_link',true );

            if(!empty($tile_icon)):
              $t_icon_path = '<img alt="" title="" src="'.$tile_icon_image[0].'"/>'; 
            else:
             $t_icon_path = '';
            endif; 

            $html .= '<div class="tile nav-tile tile-0'.$tile_width.'" style="background:'.$tile_bg_color.'">
                  <a class="tile-nav scroll-link" href="'.$tile_link.'" data-soffset="0">
                    <div class="nav-hover" style="background:'.$tile_hover_color.'">
                        <h5>'.$tile_desc.'</h5>
                        <p>'.$tile_linktext.'</p>
                     </div>
                    <span>'.get_the_title().'</span>
                    '.$t_icon_path.'
                  </a>
                </div>';

         break;

         case 'titletile':
        //Title tile
         $tile_subheadings  =  get_post_meta($post->ID,'next_metrott_subheading',true);
         $html .= '<div class="slogan tile-0'.$tile_width.'   text-left">
                  <div class="inner">
                    <h1>'.get_the_title().'</h1>
                  <h3>'.$tile_subheadings .'</h3>
                  </div>
                </div>
               <!-- Tile : Ends -->';
         break;

         case 'trasparent':
          $html .= '<div class="tile tile-0'.$tile_width.' transparent">
                </div>';
         break;


         case 'imageflip':
          //Image flips
            $tile_image_orient =  get_post_meta($post->ID,'next_metroif_orientation',true );
            $tile_flip_image   =  get_post_meta($post->ID,'next_metroif_images',false);
            $flip_slides       =  count($tile_flip_image);
            $tile_link         =  get_post_meta($post->ID,'next_metroif_link',true );

            if($tile_link!=''): $tlink = $tile_link; else: $tlink = "#"; endif;

            switch($tile_image_orient)
            {
              case 'vertical':
                $flip_dir = 'flipX'; 
                $flip = "thumb";
              break;
              case 'horizontal':
                $flip_dir = 'flipY'; 
                $flip = "thumb";
              break;      
              case 'noflip':
                $flip_dir = ''; 
                $flip = "thumb";
              break;   
            }

    $html .= '<div class="tile tile-0'.$tile_width.' thumb">
          <div class="tile-nav '.$flip_dir.'"><a href="'.$tlink.'">';
              if(!empty($tile_flip_image)):
                $slide_cnt =1;
              foreach($tile_flip_image as $tile_flip_file )
              {
                $flippy = wp_get_attachment_image_src($tile_flip_file,'full');
                $html .= '<img class="img'.$slide_cnt.'" alt="" title="" src="'.$flippy['0'].'"/>'; 
                $slide_cnt++;
              }
              endif;  
            $html .='</a></div>
                </div>';

         break;

        }

        endwhile;
        $html .= '</div></section>';


        return $html;
        }
              add_shortcode('metro_tiles', 'metro_tiles');
}

/*-------------------------------------
 Container 
--------------------------------------*/
function container($atts, $content = null)
{
  //extract(shortcode_atts(array( "customclass" => '',"fx" => ''), $atts));
  //if($fx !=''){ $colfx ='fx '.$fx.'';} else { $colfx=''; }

  $html = "\n".'<section class="container">'.do_shortcode($content).'</section>'."\n";

   return $html;
}

/*-------------------------------------
 Row 
--------------------------------------*/
if (!function_exists('row')) 
{  
  function row($atts, $content = null)
  {
    extract(shortcode_atts(array( "customclass" => '',"fx" => '','id' => ''), $atts));
    if($fx !=''){ $colfx ='fx '.$fx.'';} else { $colfx=''; }
    if($id !=''){ $rowid ='id="'.$id.'"';} else { $rowid=''; }

    $html = "\n".'<div '.$rowid.' class="row '.$customclass.' '.$colfx.'">'.do_shortcode($content).'</div>'."\n";

     return $html;
  }
        add_shortcode('row', 'row');
}
/*-------------------------------------
 Column 
--------------------------------------*/
if (!function_exists('column')) 
{  
  function column($atts, $content = null)
  {
    extract(shortcode_atts(array("span" => "4","mobile"=>"","customclass"=>"", "fx" => '','id' => ''), $atts));
   
    if($mobile !=''){ $mob ='col-xs-'.$mobile.'';} else { $mob=''; }
    if($fx !=''){ $colfx ='fx '.$fx.'';} else { $colfx=''; }
    if($id !=''){ $rowid ='id="'.$id.'"';} else { $rowid=''; }

    //Return content 
    $html = '<article '.$rowid.' class="col-md-'.$span.' '.$mob.' '.$customclass.' '.$colfx.'">'.do_shortcode($content).'</article>';
    return $html;
  }
        add_shortcode('column', 'column');
}


/*-------------------------------------
 Welcome Text 
--------------------------------------*/
if (!function_exists('welcometext')) 
{ 
  function welcometext($atts, $content = null)
  {
    extract(shortcode_atts(array("effect" => "","color"=>"#999999"), $atts));
    if($effect !=''){ $colfx ='fx fx-'.$effect.'';} else { $colfx=''; }
    //Return content  
    $html = '<p class="welcome-text '.$colfx.'" style="color:'.$color.'">
    '.$content.'</p>';
    return $html;
  }
        add_shortcode('welcometext', 'welcometext');
}
/*-------------------------------------
 Social Icons
--------------------------------------*/
if (!function_exists('socialicons')) 
{  
  function socialicons($atts, $content = null)
  {
    extract(shortcode_atts(array("span" => "12",'email' =>'','mobile'=>'','twitter'=>'','dribbble'=>''), $atts));
    //Return content  
    $html = '<article class="col-md-'.$span.' social-block text-left">';
    
      if($email !=''): 
         $html .= ' <a target="_blank" href="mailto:'.$email.'"><img alt="next" title="next" src="'.get_stylesheet_directory_uri().'/images/contact/email.png"/></a>';
      endif;
      if($mobile !=''): 
         $html .= ' <a target="_blank" href="mailto:'.$mobile.'"><img alt="'.$mobile.'" title="'.$mobile.'" src="'.get_stylesheet_directory_uri().'/images/contact/mobile.png"/></a>';
      endif;
      if($twitter !=''): 
         $html .= ' <a target="_blank" href="http://twitter.com/'.$twitter.'"><img alt="'.$twitter.'" title="'.$twitter.'" src="'.get_stylesheet_directory_uri().'/images/contact/twitter.png"/></a>';
      endif;
      if($dribbble !=''): 
         $html .= ' <a target="_blank" href="http://dribbble.com/'.$dribbble.'"><img alt="'.$dribbble.'" title="'.$dribbble.'" src="'.get_stylesheet_directory_uri().'/images/contact/dribbble.png"/></a>';
      endif;

    $html .= '</article>';
    return $html;
  }
        add_shortcode('socialicons', 'socialicons');
}



/*-------------------------------------
 Skillset
--------------------------------------*/
if (!function_exists('skill')) 
{
  function skill($atts, $content = null)
  {
    extract(shortcode_atts(array("uid" =>"","size" =>"","skillbase"=>"%","color"=>"#149CA8"), $atts));

    $html = "\n".'<article class="col-md-3 col-xs-6 text-center skill-wrap">
              <div id="'.$uid.'" class="theskill" data-color="'.$color.'" data-percent="'.$size.'">'.$size.$skillbase.'<span>'.$content.'</span></div>
            </article>'."\n";
     return $html;
  }
        add_shortcode('skill', 'skill');
}
/*-------------------------------------
 Team Memeber
--------------------------------------*/

if (!function_exists('team_member')) 
{
  function team_member($atts, $content = null)
  {
     global $post;
     extract(shortcode_atts(array("name"=>"","bg_color" => "","photo"=>"","designation"=>"",'link'=>"#"), $atts));

     $html = '<article class="col-md-4 col-xs-6 text-center team-stuff mob-hor-full">
              <a href="'.$link.'">
                    <img class="img-responsive" alt="" title="'.$name.'" src="'.$photo.'"/>
                    <h3 class="text-center" style="background:'.$bg_color.'">'.$name.'</h3>
                    <h5>'.$designation.'</h5>
              </a>
            </article>';
     return $html;
  }
      add_shortcode('team_member', 'team_member');
}


/*-------------------------------------
highlight_wrapper
--------------------------------------*/
if (!function_exists('highlights_wrapper')) 
{ 
  function highlights_wrapper($atts, $content = null)
  {
    //extract(shortcode_atts(array("title" => "","icon"=>"", "link" => "#","link_title" => "Learn More"), $atts));
    $html ='<ul class="be-social">'.do_shortcode($content).'</ul>';
      return $html;

  }
        add_shortcode('highlights_wrapper', 'highlights_wrapper');
}  
/*-------------------------------------
highlight_box
--------------------------------------*/
if (!function_exists('highlight')) 
{
  function highlight($atts, $content = null)
  {
    extract(shortcode_atts(array("title" => "","color"=>"", "link" => "#"), $atts));
    $html = '<li><a href="'.$link.'"><span style="background:'.$color.'">'.$title.'</span></a></li>';
    return $html;
  }
        add_shortcode('highlight', 'highlight');
}



/*-------------------------------------
 Carousel
--------------------------------------*/
if (!function_exists('carousel')) 
{  
  function carousel($atts, $content = null)
  {
    extract(shortcode_atts(array("unique_id" => "", "slides_count"=>"0",  "nextprev" => ""), $atts));
    if($nextprev != '') { $nextprevButton = '<a class="carousel-control left" href="#ShowCarousel-'.$unique_id.'" data-slide="prev"><img title="slide" alt="slide" src="'.get_stylesheet_directory_uri().'/images/nav-left.png"/></a>
                          <a class="carousel-control right" href="#ShowCarousel-'.$unique_id.'" data-slide="next"><img title="slide" alt="slide" src="'.get_stylesheet_directory_uri().'/images/nav-right.png"/></a>';} else {$nextprevButton = '';}

    $html = "\n".'<div id="ShowCarousel-'.$unique_id.'" class="carousel  remove-bottom slide point-left">';
    //Displaying the carousel
    $html .= '<div class="carousel-inner">'.do_shortcode($content).'</div>'. $nextprevButton.'</div>';
    return $html;
  }
        add_shortcode('carousel', 'carousel');
}  
//slide item
if (!function_exists('carousel_item')) 
{
  function carousel_item($atts, $content = null)
  {
    extract(shortcode_atts(array("active" => "no"), $atts));
    if($active == 'Yes'OR $active =="yes") { $state = 'active';} else {$state = '';}

    $html =  '<div class="item '.$state.'">
    <div class="about-promo text-center">
           '.do_shortcode($content).'
      </div></div>';
   return $html;
  }
        add_shortcode('carousel_item', 'carousel_item');
}   
//Description
if (!function_exists('carousel_description')) 
{
  function carousel_description($atts, $content = null)
  {
    //extract(shortcode_atts(array("active" => "no"), $atts));
    $html = '<p><span>'.do_shortcode($content).'</p></span>';;
    return $html;  
  }
        add_shortcode('carousel_description', 'carousel_description');
}  
//image   
if (!function_exists('carousel_image')) 
{
  function carousel_image($atts, $content = null)
  {
    extract(shortcode_atts(array("active" => "no"), $atts));
    $html = do_shortcode($content);
    return $html;  
  }
        add_shortcode('carousel_image', 'carousel_image');
}                                     
                                             

/*-------------------------------------
Renova Styled Heading
--------------------------------------*/
if (!function_exists('flicker')) 
{
  function flicker($atts, $content = null)
  {
    extract(shortcode_atts(array("unique_id" => "flickr",'photoset_id' => ''), $atts));
    $html = '<ul id="f'.$unique_id.'" class="feed flickfeeds clearfix" data-photoset="'.$photoset_id.'"></ul>';

    return $html;
  } 
        add_shortcode('flicker', 'flicker');
}


/*-------------------------------------
Sub Heading
--------------------------------------*/
if (!function_exists('sub_heading')) 
{
  function sub_heading($atts, $content = null)
  {
    //extract(shortcode_atts(array("style" => "light"), $atts));
    $html = '<h3 class="inner-sub-heading">'.do_shortcode($content).'</h3>';
    return $html;
  }  
        add_shortcode('sub_heading', 'sub_heading'); 
}

/*-------------------------------------
Heading with BG color
--------------------------------------*/
if (!function_exists('splash_h3')) 
{
  function splash_h3($atts, $content = null)
  {
    extract(shortcode_atts(array("background" => "","textcolor" => '#555'), $atts));
    $html = '<h3 class="bgheading-one text-center"><span style="background:'.$background.'; color:'.$textcolor.'">'.do_shortcode($content).'</span></h3>';
    return $html;
  }   
        add_shortcode('splash_h3', 'splash_h3');
}
/*-------------------------------------
Heading with BG color
--------------------------------------*/
if (!function_exists('bgcolor_heading')) 
{
  function bgcolor_heading($atts, $content = null)
  {
    extract(shortcode_atts(array("background" => "","textcolor" => '#555','mode' => 'h3'), $atts));
    $html = '<'.$mode.' class="bg_heading" style="background:'.$background.'; color:'.$textcolor.'">'.do_shortcode($content).'</'.$mode.'>';
    return $html;
  }   
        add_shortcode('bgcolor_heading', 'bgcolor_heading');
}
/*-------------------------------------
Text Color Wrapper
--------------------------------------*/
if (!function_exists('paragraph')) 
{
  function paragraph($atts, $content = null)
  {
    extract(shortcode_atts(array("color" => "#FFF",'class' => ''), $atts));
    $html = '<p class="'.$class.'" style="color:'.$color.' !important;">'.do_shortcode($content).'</p>';
    return $html;
  }  
        add_shortcode('paragraph', 'paragraph'); 
}
/*-------------------------------------
Dark Button
--------------------------------------*/
if (!function_exists('next_dark_button')) 
{
  function next_dark_button($atts, $content = null)
  {
    extract(shortcode_atts(array("link" => "",'label' => '','class' => '','target'=>"_self"), $atts));
    $html = '<a '.$target.' href="'.$link.'" class="btn btn-next '.$class.'">'.$label.'</a>';
    return $html;
  }
        add_shortcode('next_dark_button', 'next_dark_button');   
}

/*-------------------------------------
Fliptext
--------------------------------------*/
if (!function_exists('fliptext')) 
{
  function fliptext($atts, $content = null)
  {
    extract(shortcode_atts(array("uid"=> "","textcolor" => '#FFF','effect' => 'fade'), $atts));
    $html = '<h1 id="'.$uid.'" class="fliptext text-center" data-flipeffect="'.$effect.'" style="color:'.$textcolor.'"><span class="rotate">'.$content.'</span></h1>';
    return $html;
  }  
        add_shortcode('fliptext', 'fliptext'); 
}
/*-------------------------------------
Fliptext
--------------------------------------*/
if (!function_exists('splashwrapper')) 
{
  function splashwrapper($atts, $content = null)
  {
    extract(shortcode_atts(array("textcolor" => '#FFF','effect' => 'fade'), $atts));
    $html = '<div id="thesplashrotate">'.do_shortcode($content).'</div>';
    return $html;
  }  
        add_shortcode('splashwrapper', 'splashwrapper'); 
}
/*-------------------------------------
 Testimonial Tabs
--------------------------------------*/
if (!function_exists('testimonials_wrapper')) 
{
  function testimonials_wrapper($atts, $content = null)
  {
      $html = "\n".'<div id="cbp-qtrotator" class="cbp-qtrotator">'.do_shortcode($content).'</div>';
      return $html;
  }
        add_shortcode('testimonials_wrapper', 'testimonials_wrapper');
}
//testimonials
if (!function_exists('testimonial')) 
{
  function testimonial($atts, $content = null)
  {
      extract(shortcode_atts(array("text_color" => "#000","image" => "",'author' => ''), $atts));
      $html = "\n".'<div class="cbp-qtcontent">';

          if($image != ""):        
              $html .=  '<img alt="Testimonial" title="Testimonial" src="'.$image.'"/>';
          endif;          

      $html .=   '<blockquote>
                <p style="color:'.$text_color.'">'.do_shortcode($content).'</p>
                  <footer style="color:'.$text_color.'">'.$author.'</footer>
              </blockquote>
            </div>'; 
      return $html;
  }
        add_shortcode('testimonial', 'testimonial');
}

/*-------------------------------------
Devider Twitter Feed
--------------------------------------*/
if (!function_exists('twitterfeed')) 
{
  function twitterfeed($atts, $content = null)
  {    
    $html = '<article id="ticker" class="query"></article>';                 
    return $html;
  }
        add_shortcode('twitterfeed', 'twitterfeed');
}




/*-------------------------------------
Contact Form
--------------------------------------*/
if (!function_exists('contactform')) 
{
  function contactform($atts,$content = null)
  {
    //extract(shortcode_atts(array("heading" => ''), $atts));
    global $smof_data;
    $sendmessage_text =  __( 'Send Message', 'nextlang' );
    $html =  '<div class="row add-top add-bottom">
              <article class="col-md-12 contact-panel fx fx-rollIn">
                 <div class="row">
                  <article class="col-md-12 text-center">
                          <div id="fname"  class="alert alert-error error add-top">
                          '.esc_html($smof_data['label_name']).'
                          </div>
                          <div id="fmail" class="alert alert-error  error add-top">
                          Please provide a valid '.esc_html($smof_data['label_email']).'
                          </div>
                          <div id="fmsg" class="alert alert-error  error add-top">
                          '.esc_html($smof_data['label_message']).' 
                          </div>
                          <div class="alert alert-success success add-top">
                              '.esc_html($smof_data['msg_success']).'
                          </div>
                          <div class="alert alert-error  error add-top">
                              '.esc_html($smof_data['msg_fail']).'
                          </div>
                    </article>
                  </div>

               <form name="myform" id="contactForm" action="'.plugins_url(). '/designova-next-shortcodes/sendmail.php" enctype="multipart/form-data" method="post">  
                  <div class="row add-top-small">
                    <article class="col-md-6">
                      <input size="100" type="text" name="name" id="name" placeholder="'.esc_html($smof_data['label_name']).'">
                    </article>
                    <article class="col-md-6">
                              <input type="text"  size="30" id="email" name="email" placeholder="'.esc_html($smof_data['label_email']).'">
                   <input type="hidden" value="'.esc_html($smof_data['contact_email']).'" name="receiver"/>
                          <input type="hidden" id="subject" name="subject" value="'.esc_html($smof_data['contact_subject']).'"/>
                    </article>
                  </div>
                  <div class="row add-top-small">
                    <article class="col-md-12">
                              <textarea  id="msg" rows="3" cols="40" name="message" placeholder="'.esc_html($smof_data['label_message']).'"></textarea>
                              <button type="submit" name="submit" id="submit" class="btn btn-next add-top-half">'.$sendmessage_text.'</button>
                    </article>
                  </div>
                </form>

              </article>

          </div>';

    return $html;

  }
        add_shortcode('contactform', 'contactform');
}  
/*-------------------------------------
highlight_box
--------------------------------------*/
if (!function_exists('socialbox')) 
{
  function socialbox($atts, $content = null)
  {
    extract(shortcode_atts(array("title" => '',"url"=>"","icon"=>""), $atts));
    $html = '<div class="row-fluid add-top-small">
                  <article class="span12 contact-label-box">
                  <span><img title="'.$title.'" alt="'.$title.'" src="'.$icon.'"/></span>
                  <a href="'.$url.'">'.$title.'</a>
                  </article>
                </div>';

    return $html;            
  }
      add_shortcode('socialbox', 'socialbox');
}
/*-------------------------------------
highlight_box
--------------------------------------*/
if (!function_exists('hollowbutton')) 
{
  function hollowbutton($atts, $content = null)
  {
    extract(shortcode_atts(array("title" => '',"url"=>""), $atts));
    $html =  '<a data-soffset="0" href="'.$url.'" class="scroll-link btn-next-standard">'.$title.'</a>';
    return $html;   

  }
    add_shortcode('hollowbutton', 'hollowbutton');
}
